<?php require __DIR__ . '/../db.php'; ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" /><meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Admin • FeatureBoard</title>
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu; margin:0; background:#f6f7fb; color:#222;}
.wrap{max-width:1000px;margin:24px auto;padding:0 16px}
.card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 2px 6px rgba(0,0,0,.04);padding:16px;margin-bottom:16px}
.row{display:flex;gap:12px;align-items:center;flex-wrap:wrap}
.btn{border:1px solid #d1d5db;background:#fff;border-radius:10px;padding:8px 12px;cursor:pointer}
.btn:hover{background:#f3f4f6}
input,select{border:1px solid #d1d5db;border-radius:10px;padding:8px}
table{width:100%;border-collapse:collapse}
th,td{padding:8px;border-bottom:1px solid #eee;text-align:left}
h2{margin:8px 0 12px}
.muted{color:#6b7280}
</style>
</head>
<body>
<div class="wrap">
  <h1>Admin</h1>

  <div class="card" id="login-card">
    <h2>Login</h2>
    <div class="row">
      <input id="admin-identifier" placeholder="FeatureAdmin or email" />
      <input id="admin-password" type="password" placeholder="Password" />
      <button class="btn" id="btn-admin-login">Login</button>
      <span id="login-msg" class="muted"></span>
    </div>
    <p class="muted">Default admin: <code>FeatureAdmin</code> / <code>!1Feature3#</code></p>
  </div>

  <div id="admin-panels" style="display:none;">
    <div class="card">
      <h2>Settings</h2>
      <div class="row">
        <label>Allowed email domain: <input id="allowed-domain" placeholder="helenaagri.com"></label>
        <button class="btn" id="btn-save-domain">Save</button>
        <span id="domain-msg" class="muted"></span>
      </div>
    </div>

    <div class="card">
      <h2>Categories</h2>
      <div class="row">
        <input id="cat-name" placeholder="Category name" />
        <input id="cat-sort" type="number" value="100" />
        <button class="btn" id="btn-add-cat">Add</button>
      </div>
      <table id="cat-table"><thead><tr><th>Name</th><th>Sort</th><th></th></tr></thead><tbody></tbody></table>
    </div>

    <div class="card">
      <h2>Users & Roles</h2>
      <div class="row">
        <input id="new-admin-email" placeholder="email@example.com" />
        <input id="new-admin-name" placeholder="Name (optional)" />
        <input id="new-admin-pass" placeholder="Password" type="password" />
        <button class="btn" id="btn-create-admin">Create Admin</button>
        <span id="user-msg" class="muted"></span>
      </div>
      <div class="row">
        <input id="set-role-email" placeholder="email@example.com" />
        <select id="set-role-role"><option>user</option><option>admin</option></select>
        <button class="btn" id="btn-set-role">Set Role</button>
      </div>
      <div class="row">
        <input id="set-pass-email" placeholder="email@example.com" />
        <input id="set-pass-pass" placeholder="New password" type="password" />
        <button class="btn" id="btn-set-pass">Set Password</button>
      </div>
    </div>

    <div class="card">
      <h2>Mark Duplicate</h2>
      <div class="row">
        <input id="dup-feature-id" type="number" placeholder="Feature ID" />
        <input id="dup-of-id" type="number" placeholder="Duplicate Of (Feature ID)" />
        <button class="btn" id="btn-mark-dup">Mark Duplicate</button>
        <span id="dup-msg" class="muted"></span>
      </div>
    </div>

    <div class="card">
      <h2>Roadmap (Backlog added)</h2>
      <a class="btn" href="roadmap.php" target="_blank">Open Roadmap</a>
      <p class="muted">Columns: Backlog (1), Planned (2), In Progress (3), Released (4)</p>
    </div>
  </div>
</div>

<script>
let CSRF = null;
async function api(path,opts={}){
  const o = Object.assign({headers:{}},opts);
  if (!o.headers['Content-Type'] && o.body) o.headers['Content-Type']='application/json';
  if (!o.headers['X-CSRF-Token']) o.headers['X-CSRF-Token']=CSRF;
  const r = await fetch('api.php'+path,o);
  return r.json();
}
async function getCsrf(){ const j = await api('?action=csrf',{headers:{}}); CSRF=j.csrf; }

async function refreshLoginState(){
  const me = await api('?action=admin_me',{headers:{}});
  if (me && me.user && me.user.role==='admin'){
    document.getElementById('login-card').style.display='none';
    document.getElementById('admin-panels').style.display='block';
    const s = await api('?action=settings_get',{headers:{}});
    document.getElementById('allowed-domain').value = s.allowed_domain || '';
    loadCats();
  }
}

// Login
document.getElementById('btn-admin-login').addEventListener('click', async ()=>{
  const identifier = document.getElementById('admin-identifier').value.trim();
  const password = document.getElementById('admin-password').value;
  const j = await api('?action=admin_login',{method:'POST',body:JSON.stringify({identifier,password})});
  document.getElementById('login-msg').textContent = j.ok ? 'Logged in' : (j.error||'Failed');
  if (j.ok) refreshLoginState();
});

// Save domain
document.getElementById('btn-save-domain').addEventListener('click', async ()=>{
  const allowed_domain = document.getElementById('allowed-domain').value.trim();
  const j = await api('?action=settings_set_domain',{method:'POST',body:JSON.stringify({allowed_domain})});
  document.getElementById('domain-msg').textContent = j.ok ? 'Saved' : (j.error||'Failed');
});

// Categories
async function loadCats(){
  const rows = await api('?action=categories_list',{headers:{}});
  const tb = document.querySelector('#cat-table tbody');
  tb.innerHTML = rows.map(r=>`<tr><td>${r.name}</td><td>${r.sort_order}</td><td><button class="btn" data-id="${r.id}" data-act="del">Delete</button></td></tr>`).join('');
  tb.querySelectorAll('button[data-act="del"]').forEach(b=>{
    b.addEventListener('click', async()=>{
      const id = Number(b.dataset.id);
      const j = await api('?action=categories_delete',{method:'POST',body:JSON.stringify({id})});
      loadCats();
    });
  });
}
document.getElementById('btn-add-cat').addEventListener('click', async ()=>{
  const name = document.getElementById('cat-name').value.trim();
  const sort = Number(document.getElementById('cat-sort').value || 100);
  if(!name) return;
  await api('?action=categories_create',{method:'POST',body:JSON.stringify({name,sort_order:sort})});
  document.getElementById('cat-name').value='';
  loadCats();
});

// Users & Roles
document.getElementById('btn-create-admin').addEventListener('click', async ()=>{
  const email=document.getElementById('new-admin-email').value.trim();
  const name=document.getElementById('new-admin-name').value.trim();
  const password=document.getElementById('new-admin-pass').value;
  const j = await api('?action=users_create_admin',{method:'POST',body:JSON.stringify({email,name,password})});
  document.getElementById('user-msg').textContent = j.ok ? 'Admin created' : (j.error||'Failed');
});
document.getElementById('btn-set-role').addEventListener('click', async ()=>{
  const email=document.getElementById('set-role-email').value.trim();
  const role=document.getElementById('set-role-role').value;
  const j = await api('?action=users_set_role',{method:'POST',body:JSON.stringify({email,role})});
  document.getElementById('user-msg').textContent = j.ok ? 'Role updated' : (j.error||'Failed');
});
document.getElementById('btn-set-pass').addEventListener('click', async ()=>{
  const email=document.getElementById('set-pass-email').value.trim();
  const password=document.getElementById('set-pass-pass').value;
  const j = await api('?action=users_set_password',{method:'POST',body:JSON.stringify({email,password})});
  document.getElementById('user-msg').textContent = j.ok ? 'Password set' : (j.error||'Failed');
});

// Mark duplicate
document.getElementById('btn-mark-dup').addEventListener('click', async ()=>{
  const feature_id = Number(document.getElementById('dup-feature-id').value);
  const duplicate_of_id = Number(document.getElementById('dup-of-id').value);
  const j = await api('?action=features_mark_duplicate',{method:'POST',body:JSON.stringify({feature_id,duplicate_of_id})});
  document.getElementById('dup-msg').textContent = j.ok ? 'Marked duplicate' : (j.error||'Failed');
});

(async function init(){
  const csrf = await fetch('api.php?action=csrf'); const c = await csrf.json(); CSRF=c.csrf;
  await refreshLoginState();
})();
</script>
</body>
</html>
